//------------------------------------------------------------------------------
// Lab. 06: Obtain state feedback gain matrix for the given system.
//------------------------------------------------------------------------------

//scilab-5.5.0
//Operating System : OS X 10.9.3

//Clean the environment
clc;
clear all;
clf;

// State space representation
A=[0 1 0; 0 0 1; -1 -5 -6];
B=[0 0 1]';
C=[0 0 1];
D=0;

// Desired poles
Pd=[-1+2*%i -1-2*%i -10];

// State feedback gain matrix
K=ppol(A,B,Pd)

//Closed loop system
sys=syslin('c',A-B*K,B,C,D)

//Response of closed loop system
t=linspace(0,20,1001);
y=csim('step',t,sys) 
plot(t,y)
title('Response of the closed loop system','fontsize',4)
xlabel('Time t','fontsize',2)
ylabel('Response y(t)','fontsize',2)

